/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.apps.taskman.pa;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldType;
import filenet.vw.apps.taskman.VWTaskCore;
import filenet.vw.apps.taskman.VWTaskTabPanel;
import filenet.vw.apps.taskman.VWTaskUtil;
import filenet.vw.apps.taskman.pa.PADataFieldNode;
import filenet.vw.apps.taskman.pa.PADimensionRangesListModel;
import filenet.vw.apps.taskman.pa.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;

class PADataFieldGeneralPanel
extends VWTaskTabPanel {
    private PADataFieldNode m_node = null;
    private DimensionalRangesPanel m_rangesPanel = null;
    private int m_intFieldType = -1;
    private JTextField m_fieldName = null;
    private JTextField m_uniqueName = null;
    private JTextField m_fieldType = null;
    private JTextField m_reportingType = null;

    public PADataFieldGeneralPanel(PADataFieldNode node) {
        this.m_node = node;
        this.initLayout();
        VWTaskUtil.updateComponentOrientation(this);
    }

    public void resetProperties() throws Exception {
        if (this.m_node.getFieldName().compareToIgnoreCase("CmAcmCaseIdentifier") == 0) {
            this.m_fieldName.setText(VWResource.CaseIdentifier);
        } else {
            this.m_fieldName.setText(this.m_node.getFieldName());
        }
        this.m_fieldType.setText(VWFieldType.getLocalizedString(this.m_node.getFieldType()));
        this.m_intFieldType = this.m_node.getFieldType();
        this.m_uniqueName.setText(this.m_node.getName());
        this.m_reportingType.setText(this.m_node.isExposedToFactTablesOnly() ? VWResource.FactTablesOnlyReporting : VWResource.CubesAndFactTablesReporting);
        this.m_rangesPanel.resetProperties();
        this.m_rangesPanel.setVisible(this.m_node.getRanges() != null);
    }

    private void initLayout() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbConst = new GridBagConstraints();
        gbConst.fill = 0;
        gbConst.anchor = 23;
        gbConst.gridwidth = 1;
        gbConst.gridheight = 1;
        gbConst.weightx = 0.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(4, 10, 0, 0);
        gbConst.gridx = 0;
        ++gbConst.gridy;
        JLabel iconLabel = new JLabel(this.m_node.getIcon32(), 2);
        this.add((Component)iconLabel, gbConst);
        gbConst.fill = 2;
        gbConst.weightx = 1.0;
        gbConst.gridy = 0;
        gbConst.gridx = 1;
        gbConst.insets = new Insets(15, 10, 0, 0);
        gbConst.gridwidth = 0;
        this.add((Component)new JLabel(this.m_node.getName()), gbConst);
        ++gbConst.gridy;
        gbConst.gridx = 0;
        gbConst.fill = 1;
        gbConst.gridwidth = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 0.0;
        gbConst.insets = new Insets(10, 0, 0, 0);
        this.add((Component)this.getFieldPropertiesPanel(), gbConst);
        ++gbConst.gridy;
        gbConst.gridx = 0;
        gbConst.fill = 1;
        gbConst.gridwidth = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1000.0;
        gbConst.insets = new Insets(10, 10, 0, 5);
        this.m_rangesPanel = new DimensionalRangesPanel();
        this.add((Component)this.m_rangesPanel, gbConst);
        ++gbConst.gridy;
        gbConst.gridx = 0;
        gbConst.fill = 1;
        gbConst.gridwidth = 0;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        this.add(Box.createHorizontalStrut(1), gbConst);
    }

    private VWTaskTabPanel getFieldPropertiesPanel() {
        VWTaskTabPanel panel = new VWTaskTabPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints LABEL_CONSTRAINTS = new GridBagConstraints();
        LABEL_CONSTRAINTS.anchor = 23;
        LABEL_CONSTRAINTS.insets = new Insets(3, 10, 0, 5);
        LABEL_CONSTRAINTS.fill = 0;
        LABEL_CONSTRAINTS.gridwidth = 1;
        LABEL_CONSTRAINTS.weightx = 0.0;
        GridBagConstraints FIELD_CONSTRAINTS = new GridBagConstraints();
        FIELD_CONSTRAINTS.anchor = 23;
        FIELD_CONSTRAINTS.insets = new Insets(3, 10, 0, 5);
        FIELD_CONSTRAINTS.fill = 2;
        FIELD_CONSTRAINTS.gridwidth = 0;
        FIELD_CONSTRAINTS.weightx = 1.0;
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.UniqueName)), LABEL_CONSTRAINTS);
        this.m_uniqueName = new JTextField();
        this.m_uniqueName.setName(VWResource.UniqueName);
        this.m_uniqueName.setEditable(false);
        this.m_uniqueName.setBorder(null);
        panel.add((JTextComponent)this.m_uniqueName, (Object)FIELD_CONSTRAINTS, true);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.Field)), LABEL_CONSTRAINTS);
        this.m_fieldName = new JTextField();
        this.m_fieldName.setEditable(false);
        this.m_fieldName.setBorder(null);
        panel.add((JTextComponent)this.m_fieldName, (Object)FIELD_CONSTRAINTS, true);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.FieldType)), LABEL_CONSTRAINTS);
        this.m_fieldType = new JTextField();
        this.m_fieldType.setEditable(false);
        this.m_fieldType.setBorder(null);
        panel.add((Component)this.m_fieldType, FIELD_CONSTRAINTS);
        JTextField type = new JTextField(this.m_node.isMeasure() ? VWResource.Measure : VWResource.Dimension);
        type.setBorder(null);
        type.setEditable(false);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.Type)), LABEL_CONSTRAINTS);
        panel.add((Component)type, FIELD_CONSTRAINTS);
        panel.add((Component)new JLabel(VWResource.Label.toString(VWResource.ReportingType)), LABEL_CONSTRAINTS);
        this.m_reportingType = new JTextField();
        this.m_reportingType.setEditable(false);
        this.m_reportingType.setBorder(null);
        panel.add((Component)this.m_reportingType, FIELD_CONSTRAINTS);
        return panel;
    }

    class DimensionalRangesPanel
    extends VWTaskTabPanel {
        private JList m_boundaryList = null;
        private PADimensionRangesListModel m_boundaryModel = null;

        public DimensionalRangesPanel() {
            this.initLayout();
        }

        public void resetProperties() throws Exception {
            this.m_boundaryModel.clear();
            Object[] ranges = PADataFieldGeneralPanel.this.m_node.getRanges();
            if (ranges != null) {
                for (int i = 0; i < ranges.length; ++i) {
                    this.m_boundaryModel.add(ranges[i]);
                }
            }
        }

        private void initLayout() {
            VWToolbarBorder borderPanel = new VWToolbarBorder(VWResource.DimensionRanges, 0);
            JPanel clientPanel = borderPanel.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 23;
            c.fill = 1;
            c.gridy = 0;
            ++c.gridx;
            c.insets = new Insets(0, 0, 0, 0);
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.m_boundaryModel = new PADimensionRangesListModel();
            this.m_boundaryList = new JList(this.m_boundaryModel);
            this.m_boundaryList.setVisibleRowCount(6);
            clientPanel.add((Component)new JScrollPane(this.m_boundaryList), c);
            this.setLayout(new BorderLayout());
            this.add((Component)borderPanel, "Center");
            this.add(Box.createHorizontalStrut(200), "After");
        }

        private void addBoundary(Object value) throws VWException {
            if (value == null) {
                return;
            }
            try {
                Object obj = value;
                switch (PADataFieldGeneralPanel.this.m_node.getFieldType()) {
                    case 8: {
                        if (!(value instanceof String)) break;
                        obj = Double.valueOf((String)value);
                        break;
                    }
                    case 1: {
                        if (!(value instanceof String)) break;
                        obj = Integer.valueOf((String)value);
                        break;
                    }
                    case 16: {
                        obj = value;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unable to add boundary - current field type is invalid: " + PADataFieldGeneralPanel.this.m_node.getFieldType());
                    }
                }
                this.m_boundaryModel.add(obj);
            }
            catch (NumberFormatException ex) {
                VWTaskCore.getInstance().displayError(VWResource.InvalidFormat.toString(VWFieldType.getLocalizedString(PADataFieldGeneralPanel.this.m_node.getFieldType())));
            }
        }
    }
}

